package de.davidartmann.rosa.activity;

import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.design.widget.Snackbar;
import android.support.design.widget.TabLayout;
import android.support.v4.view.ViewPager;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.widget.ProgressBar;

import de.davidartmann.rosa.R;
import de.davidartmann.rosa.adapter.ViewPagerAdapter;
import de.davidartmann.rosa.fragment.DetailFragment;
import de.davidartmann.rosa.model.Person;
import de.davidartmann.rosa.transition.DepthPageTransformer;

public class ViewPagerActivity extends AppCompatActivity
        implements ViewPagerAdapter.IViewPagerAdapter {

    private Person person;
    private ProgressBar progressBar;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_viewpager);
        progressBar = (ProgressBar) findViewById(R.id.activity_viewpager_progressbar);
        progressBar.setVisibility(ProgressBar.VISIBLE);
        Intent intent = getIntent();
        person = (Person) intent.getSerializableExtra("person");
        initViewPager();
    }

    private void initViewPager() {
        ViewPager viewPager = (ViewPager) findViewById(R.id.activity_viewpager_pager);
        viewPager.setPageTransformer(true, new DepthPageTransformer());
        ViewPagerAdapter viewPagerAdapter =
                new ViewPagerAdapter(getSupportFragmentManager(), this, viewPager, person, this);
        viewPager.setAdapter(viewPagerAdapter);
        TabLayout tabLayout = (TabLayout) findViewById(R.id.activity_viewpager_tablayout);
        tabLayout.setupWithViewPager(viewPager);
    }

    @Override
    public void onLoaded() {
        progressBar.setVisibility(ProgressBar.INVISIBLE);
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions,
                                           @NonNull int[] grantResults) {
        Log.d("PERMISSION RESULT", "requestCode="+requestCode);
        switch (requestCode) {
            case DetailFragment.REQUEST_PERMISSION_CALL_PHONE:
                Log.d("PERMISSION RESULT", "permission received");
                if (grantResults.length > 0
                        && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                    Log.d("PERMISSION RESULT", "before make call intent");
                    //TODO: check if this is always the relevant person
                    Intent intent = new Intent(Intent.ACTION_CALL,
                            Uri.parse("tel:" + person.getPhone().trim()));
                    startActivity(Intent.createChooser(intent, "Anrufen mit"));
                } else {
                    Snackbar.make(findViewById(R.id.activity_viewpager_rootrelativelayout),
                            "Notwendige Berechtigung nicht erteilt",
                            Snackbar.LENGTH_LONG).show();
                }
                break;
        }
    }
}
